<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Lakshya</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes"> 
	<link href="./css/pages/plans.css" rel="stylesheet" type="text/css">
	<?php include('./partials/cssInclude.php')?>
</head>
<body>
<?php include('./partials/navbar.php') ?>
			<div class="container">
				<div style=' width: 300px; margin: 10px auto;'>
					<div class="alert alert-success hidden" id='alert-div'>
					</div>
					<div class="plan green" style="margin: 10px 0;" id="searchstudent-div">
						<div class="plan-header">
							<div class="plan-title">
								<h3>Forgot Password</h3>
								<p>Please enter account number</p>
								<div style='padding:5px'>
									<input type='number' id='search-accountNo' placeholder='Account number'>
									<button class="btn btn-warning search-user-btn" id='search-user'><i class="icon-search"></i></button>
								</div>
							</div>
							<div class="plan-price user-details hidden">
								<img src="./img/female.png" class="logo-img img-circle" alt="student photo" width="100" height="100" id='user-photo'>
								<h3  id='user-name'></h3>
							</div> 
						</div>
						<div class="plan-features user-details hidden">
							<ul>					
								<li><strong>Class : </strong> <span id='user-class'></span> </li>
								<li><strong>Section : </strong> <span id='user-section'></span>  </li>
								<li><strong>Roll : </strong> <span id='user-roll'></span>  </li>
							</ul>
						</div> 
						<div class="plan-actions user-details hidden">
							<a class='btn btn-danger' id='btn-resetPassword' >Reset Password</a>
							<input type='hidden' id='personId-reset'>
						</div>
					</div>
					<div class="plan green hidden" style="margin: 10px 0;" id="otpverify-div">
						<div class="plan-header">
							<div class="plan-title">
								<h3>Verify OTP</h3>
								<div style='padding:5px'>
									<input type="text" pattern="\d*" maxlength="4" id='input-otp' placeholder='Enter your 4 digit OTP'>
									<button class="btn btn-success search-user-btn" id='verify-otp'><i class="icon-ok-sign"></i></button>
								</div>
							</div>
						</div>
					</div>
				<div>	
			</div> <!-- /container-->
<?php include('./partials/jsInclude.php')?>
</body>
<script>
$('#search-user').on('click',function(){
	var accountNo=$('#search-accountNo').val();
	if(accountNo.trim().length==0){
		return false;
	}
	$(this).attr('disabled','disabled');
	$('.user-details').addClass('hidden');
	$('#alert-div').addClass('hidden');
	
	$.ajax({
		url: './Core/forgotpassword.php',
		data:{'action':'getUserProfile','accountNo':accountNo},
		method: "GET",
		success: function(data){
			$('#search-user').removeAttr('disabled');
			console.log(data);
			data=JSON.parse(data);
			if(data.success){
				$('#user-name').text(data.profile.name);
				$('#user-class').text(data.profile.class);
				$('#user-section').text(data.profile.section);
				$('#user-photo').attr('src',data.profile.img);
				if(data.profile.rollOrder!=null){
					$('#user-roll').text(data.profile.rollOrder).parent().removeClass('hidden');
				}
				else{
					$('#user-roll').parent().addClass('hidden')
				}
				$('.user-details').removeClass('hidden');
				$("#personId-reset").val(data.profile.gibbonPersonID);
			}
			else{
				ShowMessage(false, "Entered account number is invalid.");
				$("#personId-reset").val('');
			}
			
		}
	});
})
$('#btn-resetPassword').on('click', function(){
	$('#alert-div').addClass('hidden');
	$(this).attr('disabled','disabled');
	$.post( './Core/forgotpassword.php', {'action':'resetPassword','personId':$("#personId-reset").val()})
	  .done(function( data ) {
		  $('#btn-resetPassword').removeAttr('disabled');
		  debugger;
			data=JSON.parse(data);
			ShowMessage(data.success, data.message);
			if(data.success){
				$("#searchstudent-div").addClass('hidden');
				$("#otpverify-div").removeClass('hidden');
			}
	  });
});
$('#verify-otp').on('click', function(){
	$('#alert-div').addClass('hidden');
	var otp=$("#input-otp").val();
	if(isNaN(otp)){
		return false;
	}
	else if(parseInt(otp)<1000){
		return false;
	}
	$(this).attr('disabled','disabled');
	$.post( './Core/forgotpassword.php', {'action':'verifyOtp','otp':otp})
	  .done(function( data ) {
		  $('#verify-otp').removeAttr('disabled');
		  debugger;
			data=JSON.parse(data);
			ShowMessage(data.success, data.message);
			if(data.success){
				window.location.replace("resetpassword.php");
			}
	  });
});
function ShowMessage(status, message){
	var _msg="";
	if(status){
		_msg="<strong>Success! </strong>"+message;
		$("#alert-div").html(_msg).removeClass('alert-danger').addClass('alert-success').removeClass('hidden');
	}
	else{
		_msg="<strong>Sorry! </strong>"+message;
		$("#alert-div").html(_msg).removeClass('alert-success').addClass('alert-danger').removeClass('hidden');
	}
}
</script>