<?php
session_start(); // Start session

//error_reporting(E_ALL);
//ini_set('display_errors', 1);
error_reporting(0);

include 'config.php';

//$databaseServer="localhost"; 
//$databaseUsername="shiva_lakshya_dev_an"; 
//$databasePassword="P@ssword!23"; 
//$databaseName="shiva_lakshya_dev_an";

$working_key = '338CE85C0F10D13AEDC552466A9E0452'; //Shared by CCAVENUES
$access_code = 'AVTB77FC13CH29BTHC';

$conn = new mysqli($databaseServer, $databaseUsername, $databasePassword, $databaseName);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set current date as default
$current_date = date('Y-m-d');

// Retrieve records for the current date
$sql = "SELECT l.order_id, l.status AS lakshya_status, l.Time, l.bank_ref_number, l.tracking_id, l.months, l.amount, l.paidAmount, g.account_number, g.preferredname, h.name 
        FROM lakshya_online_payment_reference AS l
        LEFT JOIN gibbonperson AS g ON l.personId = g.gibbonPersonID
        LEFT JOIN gibbonschoolyear h ON l.yearid = h.gibbonSchoolYearID
        WHERE DATE(l.Time) = '$current_date' AND (l.status != 'Success' OR l.status IS NULL)";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $order_id = $row['order_id'];
        $lakshya_status = $row['lakshya_status'];
        $time = $row['Time'];
        $account_number = substr($row['account_number'], -5); // Last 5 digits of account number
        $preferred_name = $row['preferredname'];
        $amount = $row['amount'];
        $paidAmount = $row['paidAmount'];
        $paidMonths = $row['months'];
        $schoolYearName = $row['name'];
        $payment_date = date('Y-m-d', strtotime($time));
        $vouchernumber = generateVoucherNumber($conn, $payment_date);

        //echo 'API Call logic';
        $merchant_json_data = array(
            'order_no' => $order_id,
            'reference_no' => ''
        );

        $merchant_data = json_encode($merchant_json_data);
        $encrypted_data = encrypt($merchant_data, $working_key);
        $final_data = 'enc_request=' . $encrypted_data . '&access_code=' . $access_code . '&command=orderStatusTracker&request_type=JSON&response_type=JSON&version=1.2';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.ccavenue.com/apis/servlet/DoWebTrans");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);

        $api_result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'cURL error: ' . curl_error($ch);
        }

        curl_close($ch);

        $status_response = '';
        $information = explode('&', $api_result);
        $dataSize = sizeof($information);

        for ($i = 0; $i < $dataSize; $i++) {
            $info_value = explode('=', $information[$i]);
            if ($info_value[0] == 'enc_response') {
                $status_response = decrypt(trim($info_value[1]), $working_key);
            }
        }

        $status_array = json_decode($status_response, true);
        $order_status = isset($status_array['order_status']) ? $status_array['order_status'] : 'Status not found';
        $reference_no = isset($status_array['reference_no']) ? $status_array['reference_no'] : '';
        $order_bank_ref_no = isset($status_array['order_bank_ref_no']) ? $status_array['order_bank_ref_no'] : '';

        //echo $order_status;
        // Check if the row should be updated
        if ($order_status == 'Shipped' && $lakshya_status != 'Success') {
            //echo "Perform the update logic here" ;
           
            $insert_sql = "INSERT INTO payment_master (gibbonPersonID, gibbonStudentEnrolmentID, fine_amount, total_amount, net_total_amount, voucher_number, payment_mode, bankID, payment_date, transport_month_entryid, gibbonSchoolYearID, cheque_bank, `lock`, cheque_no, cheque_date)
                           SELECT l.personId, e.gibbonStudentEnrolmentID, l.fine, l.amount-l.fine, l.amount, ?, 'online', 5, DATE(l.Time), 0, l.yearid,0, 0, l.order_id, DATE(l.Time)
                           FROM lakshya_online_payment_reference l
                           LEFT JOIN gibbonstudentenrolment e ON l.personId = e.gibbonPersonID 
                           AND e.gibbonSchoolYearID = (SELECT gibbonschoolyearid FROM gibbonschoolyear WHERE status='Current')
                           WHERE l.order_id = ?";
            $stmt = $conn->prepare($insert_sql);
            $stmt->bind_param("ss", $vouchernumber, $order_id);
            $stmt->execute();
            $paymentMasterId = $conn->insert_id;
            $stmt->close();

            $update_sql = "UPDATE lakshya_online_payment_reference 
                           SET status = 'Success', 
                               tracking_id = ?, 
                               bank_ref_number = ?, 
                               payment_master_id  = ? ,
                               paidAmount = amount
                           WHERE order_id = ?";
            $stmt = $conn->prepare($update_sql);
            $stmt->bind_param("ssis", $reference_no, $order_bank_ref_no, $paymentMasterId, $order_id);
            $stmt->execute();
            $stmt->close();

            // Convert $paidMonths into an array
            $paidMonthsArray = explode(',', $paidMonths);
            $update_sql = "UPDATE fee_payable 
                           SET payment_staus = 'paid', 
                               payment_master_id = ?, 
                               payment_date = ?, 
                               voucher_number = ? 
                           WHERE gibbonPersonID = (SELECT personId FROM lakshya_online_payment_reference WHERE order_id = ?) 
                           AND gibbonSchoolYearID = (SELECT yearid FROM lakshya_online_payment_reference WHERE order_id = ?) 
                           AND month_no = ? 
                           AND payment_staus = 'unpaid'";
            $stmt = $conn->prepare($update_sql);
            foreach ($paidMonthsArray as $month) {
                $stmt->bind_param("isssss", $paymentMasterId, $payment_date, $vouchernumber, $order_id, $order_id, $month);
                $stmt->execute();
            }
            $stmt->close();
            
            echo '<p style="color: green; font-weight: bold;">Updated Order ID: ' . htmlspecialchars($order_id) . '</p>';
        }
    }
} else {
    echo "No records found for the current date.<br>";
}
//echo 'Ok done';
$conn->close();

// Function to convert numeric months to short month names
function convertMonthsToShortNames($paidMonths) {
    $monthNames = [
        1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr',
        5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug',
        9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec'
    ];
    $monthNumbers = explode(',', $paidMonths);
    $monthNamesArray = array_map(function ($monthNumber) use ($monthNames) {
        return $monthNames[(int)$monthNumber];
    }, $monthNumbers);
    return implode(', ', $monthNamesArray);
}

// ENCRYPT Function
function encrypt($plainText, $key) {
    $key = hextobin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
    $encryptedText = bin2hex($openMode);
    return $encryptedText;
}

// DECRYPT Function
function decrypt($encryptedText, $key) {
    $key = hextobin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $encryptedText = hextobin($encryptedText);
    $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
    return $decryptedText;
}

// Hexadecimal to Binary function for PHP 4.0 version
function hextobin($hexString) {
    $length = strlen($hexString);
    $binString = "";
    $count = 0;
    while ($count < $length) {
        $subString = substr($hexString, $count, 2);
        $packedString = pack("H*", $subString);
        if ($count == 0) {
            $binString = $packedString;
        } else {
            $binString .= $packedString;
        }
        $count += 2;
    }
    return $binString;
}

function generateVoucherNumber($connection, $payment_date)
{
    $sql = "SELECT Max(voucher_number) as tableid FROM payment_master where payment_date='$payment_date' AND `voucher_number`!=0";
    $result = $connection->query($sql);
    $dboutput = $result->fetch_assoc();
    $date = explode("-", $payment_date);
    $dboutput['tableid'] = (int) substr($dboutput['tableid'], -3, 3);

    if ($dboutput['tableid'] == 0) {
        $tableid = '001';
    } else {
        $tableid = $dboutput['tableid'] + 1;
        $tableidlen = strlen($tableid);

        switch ($tableidlen) {
            case 1:
                $tableid = '00' . $tableid;
                break;

            case 2:
                $tableid = '0' . $tableid;
                break;

            case 3:
                $tableid = $tableid;
                break;
        }
    }

    $vouchernumber = $date[2] . $date[1] . $tableid;
    return $vouchernumber;
}

?>