<?php 
session_start();
	if (file_exists("./dbCon.php")) {
		include "./dbCon.php" ;
	}
	
	if($_GET){
		
		if($_GET['action']=='getUserProfile'){
			$accountNo=$_GET['accountNo'];
			$profile=array();
			try{
			$data=array("accountNo"=>$accountNo); 
			$sql="SELECT p.`gibbonPersonID`,p.`preferredName` as name, p.`image_240`,p.`gender` FROM `gibbonperson` p WHERE p.`account_number`=:accountNo";
			$result=$connection1->prepare($sql);
			$result->execute($data);
			$person=$result->fetch();
			}
			catch(PDOException $e) {
			  echo $e->getMessage();
			}
			if(empty($person)){
				$success=false;
			}
			else{
				$success=true;
				$profile['name']=$person['name'];
					$maleImgSrc='./img/male.jpg';
					$femaleImgSrc='./img/female.png';
					$ImgSrc=$person['gender']=="M"?$maleImgSrc:$femaleImgSrc;
					if($person['image_240']==''){
						$profile['img']=$ImgSrc;
					}
					else{
						$profile['img']=file_exists($ImageURL.$person['image_240'])?$ImageURL.$person['image_240']:$ImgSrc;
					}
					
				$profile['gibbonPersonID']=$person['gibbonPersonID'];
				$gibbonPersonID=$person['gibbonPersonID'];
				try{
				$sql1="SELECT `gibbonyeargroup`.`name` class,`gibbonrollgroup`.`name` section,`gibbonstudentenrolment`.`rollOrder`
						FROM `gibbonstudentenrolment` 
						JOIN `gibbonschoolyear` ON `gibbonstudentenrolment`.`gibbonSchoolYearID`=`gibbonschoolyear`.`gibbonSchoolYearID`
						JOIN `gibbonyeargroup` ON `gibbonyeargroup`.`gibbonYearGroupID`=`gibbonstudentenrolment`.`gibbonYearGroupID`
						JOIN `gibbonrollgroup` ON `gibbonrollgroup`.`gibbonRollGroupID`=`gibbonstudentenrolment`.`gibbonRollGroupID`
						WHERE `gibbonstudentenrolment`.`gibbonPersonID`=$gibbonPersonID AND  `gibbonschoolyear`.`status`='Current'";
				$result1=$connection1->prepare($sql1);
				$result1->execute();
				$userProfile=$result1->fetch();
					if(!empty($userProfile)){
						$profile['class']=$userProfile['class'];
						$profile['section']=$userProfile['section'];
						$profile['rollOrder']=$userProfile['rollOrder'];
					}
				}
				catch(PDOException $e) {
				  echo $e->getMessage();
				}
			}
			echo json_encode(array('success'=>$success, 'profile'=>$profile));
		}
	}
	
	else if($_POST){
		//print_r($_REQUEST);
		if($_REQUEST['action']=='resetPassword'){
			$personId=$_REQUEST['personId']+0;
			$otp=mt_rand(1000, 9999);
			try{
			$data=array("personId"=>$personId); 
			$sql="SELECT p.`phone1` FROM `gibbonperson` p WHERE p.`gibbonPersonID`=:personId";
			$result=$connection1->prepare($sql);
			$result->execute($data);
			$person=$result->fetch();
			}
			catch(PDOException $e) {
			  echo $e->getMessage();
			}
			$phoneNo=$person["phone1"];
			
		//	 $message="Dear parents, your OTP to login is:".$otp;
		//	 $message="Dear Parents, your OTP to login is ".$otp;			 
		//   $message="Your OTP is ".$otp;
		     $message="Dear CPS User, OTP for Login Transaction on CPS Payment Portal is ".$otp.".";
			if(SendMessage($connection1, $message, $phoneNo))
			{
				$_SESSION["PasswordReset"]["OTP"]=$otp;
				$_SESSION["PasswordReset"]["failCount"]=0;
				$_SESSION["PasswordReset"]["personId"]=$personId;
				
				echo json_encode(array('success'=>true, 'message'=>"OTP has been sent to your  registered mobile number ".substr($phoneNo,0,2)."******".substr($phoneNo,8,2)."."));
			}
			else
			{
				echo json_encode(array('success'=>false, 'message'=>"We are facing technical error. Please try after sometime."));
			}
		}
		//Verify OTP
		else if($_REQUEST['action']=='verifyOtp'){
			if(isset($_SESSION["PasswordReset"]["OTP"])){
				$otp=$_REQUEST['otp'];
				if($_SESSION["PasswordReset"]["OTP"]==$otp){
					$personId=$_SESSION["PasswordReset"]["personId"];
					session_unset();
					$_SESSION["ResetPassword-personId"]=$personId;
					echo json_encode(array('success'=>true, 'message'=>"Kindly set your new password."));
				}
				else{
					$_SESSION["PasswordReset"]["failCount"]++;
					$attempt=3-$_SESSION["PasswordReset"]["failCount"];
					echo json_encode(array('success'=>false, 'message'=>"Entered otp is incorrect. You have ".$attempt." attempts left."));
				}
			}
			else
			{
				echo json_encode(array('success'=>false, 'message'=>"We are facing technical error. Please try after sometime."));
			}
		}
		else if($_REQUEST['action']=='setNewPassword'){
			if(isset($_SESSION["ResetPassword-personId"])){
				$gibbonPersonID=$_SESSION["ResetPassword-personId"];
				extract($_POST);
				$error="";
				if($new_password==$confirm_password){
					if(PasswordPolicyChecker($new_password)){
						try{
							$newSalt=getSalt();
							$newPasswordStrong=hash("sha256", $newSalt.$new_password);
							$sql="UPDATE gibbonperson SET passwordStrong='$newPasswordStrong', passwordStrongSalt='$newSalt',`passwordForceReset`='N' WHERE `gibbonPersonID`=$gibbonPersonID";
							$result=$connection1->prepare($sql);
							$result->execute();
						}
						catch(PDOException $e) {
						  echo $e->getMessage();
						}
						$error=0;
					}
					else{
						//Password policy doesn't meet.
						$error=3;
					}
				}
				else{
					//New password and confirm password doesn't match.
					$error=2;
				}
				//echo $error;
				if($error!=0){
					$changePasswordUrl="../changepassword.php";
					header('Location: '.$changePasswordUrl.'?error='.$error);
				}
				else{
					$logoutURL="../logout.php";
					header('Location: '.$logoutURL.'?pc=true');
				}
			}
			else{
				$logoutURL="../logout.php";
				header('Location: '.$logoutURL);
			}
		}
	}

function SendMessage($connection1, $message_data, $phoneNo){
	
	 $smsUsername=getSettingByScope( $connection1, "Messenger", "smsUsername" ) ;
	 $smsPassword=getSettingByScope( $connection1, "Messenger", "smsPassword" ) ;
	 $smsURL=getSettingByScope( $connection1, "Messenger", "smsURL" ) ;
	
	$sender = "JETCPS";
	
	$test = "0";
	
	$message = urlencode($message_data);
	$phoneNo= urlencode("91".$phoneNo);
	$data = "username=".$smsUsername."&hash=".$smsPassword."&message=".rawurlencode($message_data)."&sender=".$sender."&numbers=".$phoneNo."&test=".$test;
	$ch = curl_init($smsURL);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$result = curl_exec($ch); // This is the result from the API
	curl_close($ch);
	
	
	$obj = json_decode($result,true);
	// echo "<pre>";
	// print_r($obj);
	// echo "</pre>";
	return $obj["status"]=="success";
}
//Gets the desired setting, specified by name and scope.
function getSettingByScope( $connection2, $scope, $name ) {
	$output=FALSE ;
	
	try {
		$data=array("scope"=>$scope, "name"=>$name); 
		$sql="SELECT * FROM gibbonsetting WHERE scope=:scope AND name=:name" ;
		$result=$connection2->prepare($sql);
		$result->execute($data); 
	}
	catch(PDOException $e) { }
	if ($result->rowCount()==1) {
		$row=$result->fetch() ;
		$output=$row["value"] ;
	}
	
	return $output ;
}
function PasswordPolicyChecker($passwordNew){
	return preg_match('/[a-z]/',$passwordNew) && preg_match('/[A-Z]/',$passwordNew) && preg_match('/[0-9]/',$passwordNew) && strlen($passwordNew)>=8;
}
function getSalt() {
  $c=explode(" ", ". / a A b B c C d D e E f F g G h H i I j J k K l L m M n N o O p P q Q r R s S t T u U v V w W x X y Y z Z 0 1 2 3 4 5 6 7 8 9");
  $ks=array_rand($c, 22);
  $s="";
  foreach($ks as $k) { $s .=$c[$k]; }
  return $s;
}
?>