<?php
session_start(); // Start the session at the beginning of the script
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
error_reporting(0);


include 'config.php';

$working_key = '338CE85C0F10D13AEDC552466A9E0452'; //Shared by CCAVENUES
$access_code = 'AVTB77FC13CH29BTHC';

$conn = new mysqli($databaseServer, $databaseUsername, $databasePassword, $databaseName);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set default dates to current date
$default_date = date('Y-m-d');
$start_date = isset($_POST['start_date']) ? $_POST['start_date'] : '';
$end_date = isset($_POST['end_date']) ? $_POST['end_date'] : '';

// Store dates in session variables
if ($start_date && $end_date) {
    $_SESSION['start_date'] = $start_date;
    $_SESSION['end_date'] = $end_date;
}

// Retrieve dates from session variables for use in SQL query
$start_date = isset($_SESSION['start_date']) ? $_SESSION['start_date'] : '';
$end_date = isset($_SESSION['end_date']) ? $_SESSION['end_date'] : '';

// Check for action parameter
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Handle "Update" action
if ($action == 'update') {
    // Add your update logic here
    // Retrieve the data
    $sql = "SELECT l.order_id, l.status AS lakshya_status, l.Time, l.bank_ref_number, l.tracking_id, l.months, l.amount, l.paidAmount, g.account_number, g.preferredname, h.name 
            FROM lakshya_online_payment_reference AS l
            LEFT JOIN gibbonperson AS g ON l.personId = g.gibbonPersonID
            LEFT JOIN gibbonschoolyear h ON l.yearid = h.gibbonSchoolYearID
            WHERE DATE(l.Time) BETWEEN '$start_date' AND '$end_date' AND (l.status != 'Success' OR l.status IS NULL)";
            
        $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $order_id = $row['order_id'];
            $lakshya_status = $row['lakshya_status'];
            $time = $row['Time'];
            $bank_ref_number = $row['bank_ref_number'];
            $tracking_id = $row['tracking_id'];
            $account_number = substr($row['account_number'], -5); // Last 5 digits of account number
            $preferred_name = $row['preferredname'];
            $amount = $row['amount'];
            $paidAmount = $row['paidAmount'];
            $paidMonths = $row['months'];
            $schoolYearName = $row['name'];
            $payment_date = date('Y-m-d', strtotime($time));
            $vouchernumber = generateVoucherNumber($conn, $payment_date);

            // API Call logic
            $merchant_json_data = array(
                'order_no' => $order_id,
                'reference_no' => ''
            );

            $merchant_data = json_encode($merchant_json_data);
            $encrypted_data = encrypt($merchant_data, $working_key);
            $final_data = 'enc_request=' . $encrypted_data . '&access_code=' . $access_code . '&command=orderStatusTracker&request_type=JSON&response_type=JSON&version=1.2';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://api.ccavenue.com/apis/servlet/DoWebTrans");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);

            $api_result = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'cURL error: ' . curl_error($ch);
            }

            curl_close($ch);

            $status_response = '';
            $information = explode('&', $api_result);
            $dataSize = sizeof($information);

            for ($i = 0; $i < $dataSize; $i++) {
                $info_value = explode('=', $information[$i]);
                if ($info_value[0] == 'enc_response') {
                    $status_response = decrypt(trim($info_value[1]), $working_key);
                }
            }

            $status_array = json_decode($status_response, true);
            $order_status = isset($status_array['order_status']) ? $status_array['order_status'] : 'Status not found';
            $reference_no = isset($status_array['reference_no']) ? $status_array['reference_no'] : '';
            $order_bank_ref_no = isset($status_array['order_bank_ref_no']) ? $status_array['order_bank_ref_no'] : '';


            // Check if the row should be updated
            if ($order_status == 'Shipped' && $lakshya_status != 'Success') {
                // Perform the update logic here
                // For example, you might update the record in the database
                $insert_sql = "INSERT INTO payment_master (gibbonPersonID, gibbonStudentEnrolmentID, fine_amount, total_amount, net_total_amount, voucher_number, payment_mode, bankID, payment_date, transport_month_entryid, gibbonSchoolYearID, cheque_bank, `lock`, cheque_no, cheque_date)
                               SELECT l.personId, e.gibbonStudentEnrolmentID, l.fine, l.amount-l.fine, l.amount, ?, 'online', 5, DATE(l.Time), 0, l.yearid,0, 0, l.order_id, DATE(l.Time)
                               FROM lakshya_online_payment_reference l
                               LEFT JOIN gibbonstudentenrolment e ON l.personId = e.gibbonPersonID 
                               AND e.gibbonSchoolYearID = (SELECT gibbonschoolyearid FROM gibbonschoolyear WHERE status='Current')
                               WHERE l.order_id = ?";
                $stmt = $conn->prepare($insert_sql);
                $stmt->bind_param("ss", $vouchernumber, $order_id);
                $stmt->execute();
                $paymentMasterId = $conn->insert_id;
                $stmt->close();

                $update_sql = "UPDATE lakshya_online_payment_reference 
                               SET status = 'Success', 
                                   tracking_id = ?, 
                                   bank_ref_number = ?, 
                                   payment_master_id  = ? ,
                                   paidAmount=amount
                               WHERE order_id = ?";
                $stmt = $conn->prepare($update_sql);
                $stmt->bind_param("ssis", $reference_no, $order_bank_ref_no, $paymentMasterId, $order_id);
                $stmt->execute();
                $stmt->close();

                // Convert $paidMonths into an array
                $paidMonthsArray = explode(',', $paidMonths);
                // SQL query without the 'IN' clause
                $update_sql = "UPDATE fee_payable 
                               SET payment_staus = 'paid', 
                                   payment_master_id = ?, 
                                   payment_date = ?, 
                                   voucher_number = ? 
                               WHERE gibbonPersonID = (SELECT personId FROM lakshya_online_payment_reference WHERE order_id = ?) 
                               AND gibbonSchoolYearID = (SELECT yearid FROM lakshya_online_payment_reference WHERE order_id = ?) 
                               AND month_no = ? 
                               AND payment_staus = 'unpaid'";
                // Prepare the statement
                $stmt = $conn->prepare($update_sql);
                // Loop through each month and execute the query
                foreach ($paidMonthsArray as $month) {
                    // Bind parameters
                    $stmt->bind_param("isssss", $paymentMasterId, $payment_date, $vouchernumber, $order_id, $order_id, $month);
                    // Execute the statement
                    $stmt->execute();
                }
                // Close the statement
                $stmt->close();

                // Echo the updated order ID message
                   echo '<p style="color: green; font-weight: bold;">Updated Order ID: ' . htmlspecialchars($order_id) . '</p>';

                // JavaScript to wait for a few seconds and then redirect
                echo '<script>
                    setTimeout(function() {
                        window.location.href = "https://calcuttapublicschool.in/cpsonline/lakshya_green_jm/Parent/ParentLogin/Core/sai_api_status.php";
                    }, 3000); // Waits for 3000 milliseconds (3 seconds)
                </script>';
            }
        }
    } else {
        echo "No records found for the given date range.<br>";
    }
    
    $conn->close();

    echo '<p>Update logic executed.</p>';
    // For example, you might update records or perform other actions
}

// Display the form for date input
echo '<h2 style="color: #af4c4c; font-weight: bold;">HDFC/CCAvenue Gateway API Status</h2>';
echo '<form method="post" action="" class="form-container">
    Start Date: <input type="date" name="start_date" value="' . htmlspecialchars($start_date) . '" required>
    End Date: <input type="date" name="end_date" value="' . htmlspecialchars($end_date) . '" required>
    <input type="submit" value="Filter">
</form>';

$show_update_button = false; // Flag to control the visibility of the "Update" button

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if ending date is greater than or equal to starting date
    if ($end_date < $start_date) {
        die("End date must be greater than or equal to start date.");
    }
    
    // Validate date difference
    $startDateObj = new DateTime($start_date);
    $endDateObj = new DateTime($end_date);
    $dateDiff = $startDateObj->diff($endDateObj)->days;

    if ($dateDiff > 7) {
        die("The difference between starting date and ending date should not be more than 7 days.");
    }

    // SQL query to fetch the data
    $sql = "SELECT l.order_id, l.status AS lakshya_status, l.Time, l.bank_ref_number, l.tracking_id, l.months, l.amount, l.paidAmount, g.account_number, g.preferredname,h.name 
            FROM lakshya_online_payment_reference AS l
            LEFT JOIN gibbonperson AS g ON l.personId = g.gibbonPersonID
            LEFT JOIN gibbonschoolyear h ON l.yearid = h.gibbonSchoolYearID
            WHERE DATE(l.Time) BETWEEN '$start_date' AND '$end_date'"; //AND (l.status != 'Success' OR l.status IS NULL)";
    
    $result = $conn->query($sql);

    echo '<style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #af4c4c;
            color: white;
        }
        .highlight {
            background-color: #ff0000; /* Red background color */
            color: white; /* White text color */
        }
        .return-button {
            display: inline-block;
            width: 150px;
            margin: 10px;
            padding: 10px;
            background-color: #007BFF; /* Blue background color */
            color: white;
            text-align: center;
            font-weight: bold;
            text-decoration: none;
            border-radius: 5px;
        }
        .return-button:hover {
            background-color: #0056b3; /* Darker blue on hover */
        }
        .update-button {
            display: inline-block;
            width: 150px;
            margin: 10px;
            padding: 10px;
            background-color: #ff0000; /* Red background color */
            color: white;
            text-align: center;
            font-weight: bold;
            text-decoration: none;
            border-radius: 5px;
        }
        .update-button:hover {
            background-color: #cc0000; /* Darker red on hover */
        }
        .red-row {
            background-color: #ff0000; /* Red background color */
            color: white; /* White text color */
        }
        .green-row {
            background-color: #73cf73; /* Green background color */
            color: black; /* Black text color */
        }        
    </style>';

    echo '<table>';
    echo '<tr>
            <th>Order ID</th>
            <th>Lakshya Status</th>
            <th>Order Status</th>
            <th>Date/Time</th>
            <th>Bank Ref Number</th>
            <th>Tracking ID</th>
            <th>Account Number</th>
            <th>Preferred Name</th>
            <th>Amount</th>
            <th>Paid Amount</th>
            <th>Paid Months</th>
            <th>Year</th>
          </tr>';

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $order_id = $row['order_id'];
            $lakshya_status = $row['lakshya_status'];
            $time = $row['Time'];
            $bank_ref_number = $row['bank_ref_number'];
            $tracking_id = $row['tracking_id'];
            $account_number = substr($row['account_number'], -5); // Last 5 digits of account number
            $preferred_name = $row['preferredname'];
            $amount = $row['amount'];
            $paidAmount = $row['paidAmount'];
            $paidMonths = $row['months'];
            $schoolYearName = $row['name'];

            // Convert numeric month to short month names
            $paidMonthsNames = convertMonthsToShortNames($paidMonths);

            $merchant_json_data = array(
                'order_no' => $order_id,
                'reference_no' => ''
            );

            $merchant_data = json_encode($merchant_json_data);
            $encrypted_data = encrypt($merchant_data, $working_key);
            $final_data = 'enc_request=' . $encrypted_data . '&access_code=' . $access_code . '&command=orderStatusTracker&request_type=JSON&response_type=JSON&version=1.2';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://api.ccavenue.com/apis/servlet/DoWebTrans");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_VERBOSE, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);

            $api_result = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'cURL error: ' . curl_error($ch);
            }

            curl_close($ch);

            $status_response = '';
            $information = explode('&', $api_result);
            $dataSize = sizeof($information);

            for ($i = 0; $i < $dataSize; $i++) {
                $info_value = explode('=', $information[$i]);
                if ($info_value[0] == 'enc_response') {
                    $status_response = decrypt(trim($info_value[1]), $working_key);
                }
            }

            $status_array = json_decode($status_response, true);
            $order_status = isset($status_array['order_status']) ? $status_array['order_status'] : 'Status not found';
            $reference_no = isset($status_array['reference_no']) ? $status_array['reference_no'] : '';
            $order_bank_ref_no = isset($status_array['order_bank_ref_no']) ? $status_array['order_bank_ref_no'] : '';

            // Apply highlight class based on condition
            $highlight_class = ($order_status == 'Shipped' && $lakshya_status != 'Success') ? 'highlight' : '';

            // Add CSS class based on condition
            $row_class = '';
            if ($order_status == 'Shipped' && $lakshya_status == 'Success') {
                $row_class = 'green-row';
            } elseif ($order_status == 'Shipped' && $lakshya_status != 'Success') {
                $row_class = 'red-row';
            }


            if ($order_status == 'Shipped' && $lakshya_status != 'Success') {
                $show_update_button = true; // Set flag to show the "Update" button
            }
            
            echo '<tr class="' . $row_class . '">';
            echo '<td>' . htmlspecialchars($order_id) . '</td>';
            echo '<td>' . htmlspecialchars($lakshya_status) . '</td>';
            echo '<td>' . htmlspecialchars($order_status) . '</td>';
            echo '<td>' . htmlspecialchars($time) . '</td>';
            echo '<td>' . htmlspecialchars($order_bank_ref_no) . '</td>';
            echo '<td>' . htmlspecialchars($reference_no) . '</td>';
            echo '<td>' . htmlspecialchars($account_number) . '</td>';
            echo '<td>' . htmlspecialchars($preferred_name) . '</td>';
            echo '<td>' . htmlspecialchars($amount) . '</td>';
            echo '<td>' . htmlspecialchars($paidAmount) . '</td>';
            echo '<td>' . htmlspecialchars($paidMonthsNames) . '</td>';
            echo '<td>' . htmlspecialchars($schoolYearName) . '</td>';
            echo '</tr>';
        }
    } else {
        echo '<tr><td colspan="12">No records found</td></tr>';
    }
    echo '</table>';

    // Display the "Update" button if the flag is set
    if ($show_update_button) {
        echo '<a href="?action=update" class="update-button">Update</a>';
    }

    // Display the "Return" button
    echo '<a href="https://calcuttapublicschool.in/lakshya/lakshya_green_jm//index.php" class="return-button">Return</a>'; // Adjust the return link as needed

    $conn->close();
}

// Function to convert numeric months to short month names
function convertMonthsToShortNames($paidMonths) {
    $monthNames = [
        1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr',
        5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug',
        9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec'
    ];
    $monthNumbers = explode(',', $paidMonths);
    $monthNamesArray = array_map(function ($monthNumber) use ($monthNames) {
        return $monthNames[(int)$monthNumber];
    }, $monthNumbers);
    return implode(', ', $monthNamesArray);
}

// ENCRYPT Function
function encrypt($plainText, $key) {
    $key = hextobin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
    $encryptedText = bin2hex($openMode);
    return $encryptedText;
}

// DECRYPT Function
function decrypt($encryptedText, $key) {
    $key = hextobin(md5($key));
    $initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
    $encryptedText = hextobin($encryptedText);
    $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
    return $decryptedText;
}

// Hexadecimal to Binary function for PHP 4.0 version
function hextobin($hexString) {
    $length = strlen($hexString);
    $binString = "";
    $count = 0;
    while ($count < $length) {
        $subString = substr($hexString, $count, 2);
        $packedString = pack("H*", $subString);
        if ($count == 0) {
            $binString = $packedString;
        } else {
            $binString .= $packedString;
        }
        $count += 2;
    }
    return $binString;
}

function generateVoucherNumber($connection, $payment_date)
{
    $sql = "SELECT Max(voucher_number) as tableid FROM payment_master where payment_date='$payment_date' AND `voucher_number`!=0";
    $result = $connection->query($sql);
    $dboutput = $result->fetch_assoc();
    $date = explode("-", $payment_date);
    $dboutput['tableid'] = (int) substr($dboutput['tableid'], -3, 3);

    if ($dboutput['tableid'] == 0) {
        $tableid = '001';
    } else {
        $tableid = $dboutput['tableid'] + 1;
        $tableidlen = strlen($tableid);

        switch ($tableidlen) {
            case 1:
                $tableid = '00' . $tableid;
                break;

            case 2:
                $tableid = '0' . $tableid;
                break;

            case 3:
                $tableid = $tableid;
                break;
        }
    }

    $vouchernumber = $date[2] . $date[1] . $tableid;
    return $vouchernumber;
}
?>
