<?php
session_start();
if(!isset($_SESSION['admin'])){
	$loginUrl="./login.php";
	header('Location: '.$loginUrl);
	die();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Lakshya</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes"> 
	<link href="./css/pages/plans.css" rel="stylesheet" type="text/css">
	<?php include('./partials/cssInclude.php')?>
</head>
<body>
<?php include('./partials/navbar.php') ?>
			<div class="container">
				<div style=' width: 300px; margin: 10px auto;'>
					<div class="plan green" style="margin: 10px 0;">
						<div class="plan-header">
							<div class="plan-title">
								<h3>Welcome Admin</h3>
								<h3><?=$_SESSION['admin']['preferredName']?></h3>
								<div style='padding:5px'>
									<input type='number' id='user-acc-no' placeholder='Account No'>
									<button class="btn btn-warning search-user-btn" id='search-user'><i class="icon-search"></i></button>
								</div>
							</div>
							<div class="plan-price user-details hidden">
								<img src="./img/female.png" class="logo-img img-circle" alt="student photo" width="100" height="100" id='user-photo'>
								<h3  id='user-name'></h3>
							</div> 
						</div>
						<div class="plan-features user-details hidden">
							<ul>					
								<li><strong>Class : </strong> <span id='user-class'></span> </li>
								<li><strong>Section : </strong> <span id='user-section'></span>  </li>
								<li><strong>Roll : </strong> <span id='user-roll'></span>  </li>
							</ul>
						</div> 
						<div class="plan-actions user-details hidden">
							<a class='btn btn-danger' id='btn-login-as' >Login As</a>
							<form action='Core/admin.php' method='post' id='form-login-as'>
								<input type='hidden' name='action' value='LoginAsUser' />
								<input type='hidden' name='userPersonId' value=''  id='user-personId'/>
							</form>
						</div>
					</div>
				<div>	
			</div> <!-- /container-->
<?php include('./partials/jsInclude.php')?>
</body>
<script>
$('#search-user').on('click',function(){
	var UserAccNo=$('#user-acc-no').val();
	if(UserAccNo.trim().length==0){
		return false;
	}
	$(this).attr('disabled','disabled');
	$('.user-details').addClass('hidden');
	$.ajax({
		url: './Core/admin.php',
		data:{'action':'getUserProfile','UserAccNo':UserAccNo},
		method: "GET",
		success: function(data){
			$('#search-user').removeAttr('disabled');
			console.log(data);
			data=JSON.parse(data);
			if(data.success){
				$('#user-personId').val(data.profile.gibbonPersonID);
				$('#user-name').text(data.profile.name);
				$('#user-class').text(data.profile.class);
				$('#user-section').text(data.profile.section);
				$('#user-photo').attr('src',data.profile.img);
				if(data.profile.rollOrder!=null){
					$('#user-roll').text(data.profile.rollOrder).parent().removeClass('hidden');
				}
				else{
					$('#user-roll').parent().addClass('hidden')
				}
				$('.user-details').removeClass('hidden');
			}
			else{
				alert("Invalid account number");
				$('#user-personId').val('')
			}
			
		}
	});
})
$('#btn-login-as').on('click', function(){
	var personId=$('#user-personId').val();
	if(personId.trim().length>0){
		$('#form-login-as').submit();
	}
})
</script>