<?php
session_start();
date_default_timezone_set('Asia/Kolkata');
if(!isset($_SESSION['admin'])){
	$loginUrl="./login.php";
	header('Location: '.$loginUrl);
	die();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Lakshya</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes"> 
	<link href="./css/pages/plans.css" rel="stylesheet" type="text/css">
	<?php include('./partials/cssInclude.php')?>
</head>
<body>
<?php include('./partials/navbar.php') ?>
	<div class="container">
		<div class="row">
			<div class="span12">
				<div class="widget widget-table action-table">
					<div class="widget-header"> <i class="icon-th-list"></i>
						<h3>Payment History</h3>
						<div class="controls year-dropdown">
                            From : <input type="date" name='startDate' id='startDate' value="<?=date("Y-m-d")?>"/>       
                            To : <input type="date" name='endDate' id='endDate'  value="<?=date("Y-m-d")?>"/>
							<button id="search-transaction" class="btn btn-warning"><i class="icon-large icon-search"></i></button>
                        </div>
										
					</div>
							<!-- /widget-header -->
					<div class="widget-content" style="width:100%; overflow-x:auto">
						<table class="table table-striped table-bordered" id='transaction-table'>
							<thead>
							 <tr>
								<th> Order Id </th>
								<th> Tracking Id</th>
								<th> Bank Ref No</th>
								<th class="td-actions"> Status</th>
								<th> Name</th>
								<th> Account No</th>
								<th> Time</th>
								<th> Amount</th>
								<th> Payment Id</th>
								<th> Query</th>
							</tr>
							</thead>
							<tbody>
								  
							</tbody>
						</table>
					</div><!-- /widget-content --> 
				</div>
			</div> <!-- /span12 -->
		</div> <!-- /row-->
	</div> <!-- /container-->
<?php include('./partials/jsInclude.php')?>
</body>
<div id="statusModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Transaction Status</h4>
      </div>
      <div class="modal-body" id='transaction-status-content'>
		<p><b>Amount: </b><span class='amount'></span></p>
		<p><b>Order Status: </b><span class='order_status'></span></p>
		<p><b>Reference No: </b><span class='reference_no'></span></p>
		<p><b>Bank Response: </b><span class='bank_response'></span></p>
		<p><b>Bank Reference: </b><span class='bank_ref_no'></span></p>
      </div>
      <div class="modal-footer">
		<input type='hidden' id='api-data-update' value=''>
        <button type="button" class="btn btn-danger" data-dismiss="modal" id="confirm-payment-update">Update Payment</button>
      </div>
    </div>

  </div>
</div>

<script>
$("#search-transaction").on('click',function(){
	var startDate=$('#startDate').val();
	var endDate=$('#endDate').val();
	
	var start=new Date(startDate);
	var end=new Date(endDate);
	var diff=new Date(end-start);
	var noOfDays=diff/1000/60/60/24;
	if(noOfDays>7){
		alert("Please select the date range withing 7days");
		return false;
	}
	$.ajax({
		url:'./Core/settlement.php',
		data:{'action':'GetTransaction', 'startDate': startDate, 'endDate': endDate},
		success:function(data){
			var tbody=$("#transaction-table tbody");
			$(tbody).html('');
			try{
				var results=JSON.parse(data);
				$.each(results, function(i, val){
					RenderRow(val,tbody);
				})
				$(".enquiry-data").each(function(){
					QueryOrderId ($(this));
				});
			}
			catch(e){
				console.log(e);
			}
		}
	});
});

function QueryOrderId (elem){
	var dbData=JSON.parse($(elem).val());
	var orderId=dbData.order_id;
	var url="./Core/api.php";
	$.ajax({
		url:url,
		data:{'action':'orderStatusTracker', 'orderNo':orderId},
		success:function(data){
			try{
				var result=JSON.parse(data);
				
				console.log(result);
				var Order_Status=result.Order_Status_Result;
				$(elem).parent().find('.progress').remove();
				if(Order_Status.order_status=='Shipped' || Order_Status.order_status=='Successful'){
					$(elem).parent().append(GetButton(Order_Status));
				}
				else{
					$(elem).parents("tr").remove();
				}
			}
			catch(e){
				console.log(e);
			}
			
		}
	});
	
}
$(document).on('click','.updatePayment',function(){
	var Order_Status=$(this).data("api");
	$("#api-data-update").val(JSON.stringify(Order_Status));
	var modalContent=$("#transaction-status-content");
	$(modalContent).find('.amount').html(Order_Status.order_gross_amt+ " " +Order_Status.order_currncy);
	$(modalContent).find('.order_status').html(Order_Status.order_status);
	$(modalContent).find('.reference_no').html(Order_Status.reference_no);
	$(modalContent).find('.bank_response').html(Order_Status.order_bank_response);
	$(modalContent).find('.bank_ref_no').html(Order_Status.order_bank_ref_no);
	$("#statusModal").modal();
});

$("#confirm-payment-update").on('click',function(){
	var apiData=$("#api-data-update").val();
	var url="./Core/settlement.php";
	$.ajax({
		url:url,
		method:'POST',
		data:{'action':'ConfirmPayment', 'apiData':apiData},
		success:function(data){
			console.log(data);
			
		}
	});
});

var progressBar="<div class='progress progress-warning progress-striped active'> <div class='bar' style='width: 100%;'> Querying... </div> </div>";
function RenderRow(row, table_tbody){
	var tr="<tr><td>"+row.order_id+"</td><td>"+row.tracking_id+"</td><td>"+row.bank_ref_number+"</td><td>"+row.status+"</td>";
	tr+="<td>"+row.name+"</td><td>"+row.account_number+"</td><td>"+row.Time+"</td><td>"+row.amount+"</td><td>"+row.payment_master_id+"</td>";
	tr+="<td>"+progressBar+SetData(row)+"</td>";
	tr+="</tr>";
	
	$(table_tbody).append(tr);
}

function SetData(data){
	return "<input type='hidden' class='enquiry-data' value='"+JSON.stringify(data)+"'>";
}
function GetButton(data){
	return "<button type='button' class='btn btn-danger updatePayment' data-api='"+JSON.stringify(data)+"'>Update Payment</button>";
}

</script>